//
//	Class definition for Roster of the Dead Dialog
//

#ifndef THE_ROSTEROFDEAD_DIALOG_H
#define THE_ROSTEROFDEAD_DIALOG_H

#include "ldwTiledDialog.h"

class ldwTextControl;
class ldwButton;
class ldwImage;

class CRosterOfDeadDialog : public ldwTiledDialog
{
public:
	enum {eRosterLineCount = 10};

	CRosterOfDeadDialog();
	~CRosterOfDeadDialog();

	int  GetResult();

	bool HandleMessage(int messageId,long data);
	bool HandleMouse(int messageId,ldwPoint location);

#if _DEBUG
	bool HandleKey(int messageId,int keyCode,int character);

	bool mDebug;
	int  mExtraX;
	int  mExtraY;
	
#endif

private:

	void UpdateList();

	enum {eDoneButtonId = 1,eScrollUpButtonId,eScrollDownButtonId};

	int mPageIndex;
	int mListCount;

	int mScrollKnobHeight;
	int mScrollKnobPos;
	int mScrollTrackHeight;
	int mScrollRange;

	bool mCanScroll;

	ldwButton *mScrollUpButton;
	ldwButton *mScrollDownButton;

	ldwTextControl *mpLineNumberField[eRosterLineCount];
	ldwTextControl *mpNameField[eRosterLineCount];
	ldwTextControl *mpAgeField[eRosterLineCount];
	ldwTextControl *mpOccupationField[eRosterLineCount];
	ldwTextControl *mpCauseOfDeathField[eRosterLineCount];

	ldwImage *mScrollTrack;
	ldwImage *mScrollKnob;

	int mScrollTrackX;
	int mScrollTrackY;
	int mScrollKnobX;

	bool mTrackingMouse;
	int  mMouseDownY;
	int  mMouseDownScrollKnobPos;

protected:

	void DrawNoFadeScene();

	int mResult;
};

#endif
